{
	saved_numSearches [0]
	saved_firstTime [1]

	BombsAway[ (xPos, yPos, zPos)
	{
		offset = 4000;
		y1 = yPos + offset;
		y2 = yPos - offset;

		PlaySound(3,6,true);
		Level.CreateEffect(55,61,0,xPos,y1,zPos,128,14,72,72);
		Level.CreateEffect(55,61,0,xPos,y2,zPos,128,14,72,72);

		Level.GetPlayer().ShakeHere( xPos, yPos );
		Level.GetPlayer().DamageHere( xPos, yPos,3000,8 );
	}]

	BreachBuilding[ ()
	{
		return;
	}]


	BriefRunField[ ()
	{
		TurnTo( Level.GetPlayer() );
		PlayAnimation(7);
		Delay(4,20);
		PlaySound( 57, 100, 1 ); // "Theyve got us zeroed in, we are dead if we stay here!"
	}]

	BriefTrench[ ()
	{
		CrouchFace();
		PlaySound( 58, 100, 1); // "Stay low, they got snipers out there"
		Delay(5,10);
	}]

	CrouchFace[ ()
	{
		SetCrouching();
		PlayAnimation(8);
		TurnTo( Level.GetPlayer() );
	}]

	DoSlaughter[ ()
	{
		Level.Slaughter();
	}]

	EverybodyRun[ ()
	{
		StopTurnTo();
		Level.saved_RunField = 1;

		Level.GetEntity("trunr1").GoPath("RunWall1",0);
		Level.GetEntity("trunr2").GoPath("RunWall2",0);
		Level.GetEntity("trunr3").GoPath("RunWall3",0);

		GoPath( "RunWall4", 0 );
	}]

	GoPath[ (path, mode)
	{
		if( mode=0 )
		{
			SetRunning();
			PlayAnimation(0);
		}
		if( mode=1 )
		{
			SetWalking();
			PlayAnimation(1);
		}
		if( mode=2 )
		{
			SetRunning();
			PlayAnimation(0);

			FollowPath(path,2);
			FollowPathCallback(127, "PauseFollowingPath" );
			FollowPathCallback( 127, "Delay", 5, 105);
		}
		else
		{
			FollowPath(path);
			FollowPathCallback( 127, "PlayAnimation", 7);
		}
	}]

	FightUpstairs[ ()
	{
		GoPath( "Stair1A", 0);
		FollowPathCallback(2, "DoSlaughter");
		FollowPathCallback(127,"SearchBuilding");
	}]

	GoPatrol[ (mode)
	{
		SetWander(0);
		SetState_Patrol(0);

		if( mode=0 )
		{
			// outdoor
			SetAttackDistance(30,30);
			SetLineOfSight(0);
		}
		if( mode=1 )
		{
			// indoor
			SetAttackDistance(15,2);
			SetLineOfSight(1);
		}
	}]

	NewSearch[ ()
	{
		if( saved_numSearches = 2 )
		{
			// round trip
			saved_numSearches = 0;
			StopFollowingPath();
			Delay(Random(2,5),50);
		}
		else
		{
			// just starting along path
			saved_numSearches = saved_numSearches+ 1;
		}
	}]

	SearchBuilding[ ()
	{
		Level.Spew( "### SEARCHING BUILDING ###");

		n = Random(0,3);
		path = "";

		switch (n)
		{
			case 0 { path="2FloorA"; }
			case 1 { path="2FloorB"; }
			case 2 { path="2FloorC"; }
			case 3 { path="2FloorD"; }
		}

		GoPath( path, 2 );
	}]

	Init[ ()
	{
		if(saved_firstTime = 1)
		{
			saved_firstTime = 0;
			SetNationality(3);
			SetInvulnerable(1);

			PlayAnimation(7);
			GiveWeapon(60); // MosNag
		}
	}]

	DelayReached[ (dy)
	{
		if( dy=10 )
		{
			// Been Briefed before entering trench
			//
			Level.GetPlayer().SetFrozen( false );

			StopTurnTo();
			SetRunning();
			PlayAnimation(0);
			FollowPath("TrenchPath");
			FollowPathCallback( 127, "CrouchFace" );
		}

		if( dy=20 )
		{
			EverybodyRun();
			Delay(3,30);
		}

		if( dy=30 )
		{
			if( Level.saved_AtPhase4 = 0 )
			{
				xPos = Random(7000,13700);
				yPos = Random(13700,27000);
				zPos = 175;

				BombsAway(xPos,yPos,zPos);
				Delay(1,30);
			}
		}
		if( dy=50 )
		{
			SearchBuilding();
		}

		if( dy=105 )
		{
			ResumeFollowingPath();
			FollowPathCallback( 0, "Delay", 3, 50 );
			FollowPathCallback( 0, "StopFollowingPath" );
		}
	}]
}